/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.ftb.ftbsbc.config.FTBSBConfig;
import dev.ftb.ftbsbc.dimensions.DimensionsManager;
import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockDataKjs;
import dev.ftb.ftbsbc.dimensions.level.DimensionStorage;
import dev.ftb.ftbsbc.dimensions.level.DynamicDimensionManager;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StartStructure;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StartStructurePiece;
import dev.ftb.ftbsbc.dimensions.net.SyncArchivedDimensions;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class DimensionsMain {
    public static final int SIZE = 128;
    public static final int HEIGHT = 256;
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation OVERWORLD = new ResourceLocation("overworld");

    public static void setup() {
        TeamEvent.PLAYER_LEFT_PARTY.register(DimensionsMain::teamPlayerLeftParty);
        TeamEvent.PLAYER_JOINED_PARTY.register(DimensionsMain::teamPlayerJoin);
        LifecycleEvent.SERVER_STARTED.register(DimensionsMain::serverStart);
        PlayerEvent.PLAYER_JOIN.register(DimensionsMain::syncDimensions);
    }

    private static void syncDimensions(ServerPlayer player) {
        new SyncArchivedDimensions(DimensionStorage.get(player.f_8924_).getArchivedDimensions()).sendTo(player);
    }

    private static void teamPlayerJoin(PlayerJoinedPartyTeamEvent event) {
        Team team = event.getTeam();
        if (team.getType() != TeamType.PARTY || team.getOwner() == event.getPlayer().m_142081_()) {
            return;
        }
        ResourceKey<Level> dimension = DimensionsManager.INSTANCE.getDimension(team);
        if (dimension == null) {
            return;
        }
        BlockPos blockPos = DimensionStorage.get(event.getPlayer().f_8924_).getDimensionSpawnLocations(dimension.m_135782_());
        if (blockPos != null) {
            event.getPlayer().m_9158_(dimension, blockPos, 0.0f, true, false);
            DynamicDimensionManager.teleport(event.getPlayer(), dimension);
        }
    }

    private static void serverStart(MinecraftServer minecraftServer) {
        ServerLevel level = minecraftServer.m_129880_(Level.f_46428_);
        if (level == null) {
            LOGGER.warn("Missed spawn reset event due to overworld being null");
            return;
        }
        if (DimensionStorage.get(minecraftServer).isLobbySpawned() && !level.m_8900_().equals((Object)DimensionStorage.get(minecraftServer).getLobbySpawnPos())) {
            level.m_8733_(DimensionStorage.get(minecraftServer).getLobbySpawnPos(), 180.0f);
            LOGGER.info("Updating shared spawn to the lobby location");
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent event) {
        if (event.getEntity().f_19853_.m_46472_().equals((Object)Level.f_46428_) && event.getSource() != DamageSource.f_19317_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.m_46472_().m_135782_().equals((Object)OVERWORLD) || StoneBlockDataKjs.lobbyStructure == null || DimensionStorage.get(event.getWorld().m_142572_()).isLobbySpawned()) {
            if (StoneBlockDataKjs.lobbyStructure == null) {
                LOGGER.warn("Lobby structure not defined in kubejs");
            }
            return;
        }
        if (!level.m_46472_().m_135782_().equals((Object)OVERWORLD)) {
            BlockPos dimSpawn = DimensionStorage.get(event.getWorld().m_142572_()).getDimensionSpawnLocations(((ServerLevel)event.getWorld()).m_46472_().m_135782_());
            if (!level.m_8900_().equals((Object)dimSpawn)) {
                level.m_8733_(dimSpawn == null ? BlockPos.f_121853_.m_6630_(1) : dimSpawn, 0.0f);
            }
        }
        StructureTemplate lobby = level.m_8875_().m_74341_(StoneBlockDataKjs.lobbyStructure);
        StructurePlaceSettings placeSettings = StartStructurePiece.makeSettings(lobby);
        BlockPos spawnPos = StartStructure.locateSpawn(lobby, placeSettings);
        BlockPos lobbyLoc = BlockPos.f_121853_.m_142082_(-(lobby.m_163801_().m_123341_() / 2), 0, -(lobby.m_163801_().m_123343_() / 2));
        BlockPos playerSpawn = spawnPos.m_142082_(lobbyLoc.m_123341_(), lobbyLoc.m_123342_(), lobbyLoc.m_123343_());
        lobby.m_74536_((ServerLevelAccessor)level, lobbyLoc, lobbyLoc, placeSettings, level.f_46441_, 3);
        DimensionStorage.get(event.getWorld().m_142572_()).setLobbySpawnPos(playerSpawn);
        DimensionStorage.get(event.getWorld().m_142572_()).setLobbySpawned(true);
        level.m_7471_(playerSpawn, false);
        LOGGER.info("Spawned lobby structure");
    }

    private static void teamPlayerLeftParty(PlayerLeftPartyTeamEvent event) {
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer != null) {
            ResourceKey<Level> dimensionId = DimensionStorage.get(event.getPlayer().f_8924_).getDimensionId(event.getTeam());
            if (dimensionId == null) {
                return;
            }
            if (((Boolean)FTBSBConfig.DIMENSIONS.clearPlayerInventory.get()).booleanValue()) {
                serverPlayer.m_150109_().m_36022_(arg -> true, -1, (Container)serverPlayer.f_36095_.m_39730_());
                serverPlayer.f_36096_.m_38946_();
                serverPlayer.f_36095_.m_6199_((Container)serverPlayer.m_150109_());
            }
            if (event.getTeamDeleted()) {
                DimensionStorage dimensionStorage = DimensionStorage.get(event.getPlayer().f_8924_);
                dimensionStorage.archiveDimension(event.getTeam());
                new SyncArchivedDimensions(dimensionStorage.getArchivedDimensions()).sendToAll(serverPlayer.f_8924_);
            }
            DynamicDimensionManager.teleport(serverPlayer, (ResourceKey<Level>)Level.f_46428_);
            serverPlayer.m_9158_(Level.f_46428_, DimensionStorage.get(serverPlayer.f_8924_).getLobbySpawnPos(), 180.0f, true, false);
        }
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinWorldEvent event) {
        Entity entity;
        if (event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (event.getWorld().m_46472_().m_135782_().equals((Object)OVERWORLD) && player.m_8963_().m_135782_().equals((Object)OVERWORLD)) {
            BlockPos lobbySpawnPos = DimensionStorage.get(player.f_8924_).getLobbySpawnPos();
            if (player.m_8961_() == null || !player.m_8961_().equals((Object)lobbySpawnPos)) {
                player.m_9158_(event.getWorld().m_46472_(), lobbySpawnPos, -180.0f, true, false);
                player.m_8999_((ServerLevel)event.getWorld(), (double)lobbySpawnPos.m_123341_(), (double)lobbySpawnPos.m_123342_(), (double)lobbySpawnPos.m_123343_(), -180.0f, -10.0f);
            }
        }
        DimensionsMain.swapGameMode((ResourceKey<Level>)event.getWorld().m_46472_(), player);
    }

    @SubscribeEvent
    public static void onLeaveLevel(EntityLeaveWorldEvent event) {
        Entity entity;
        if (event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DimensionsMain.swapGameMode((ResourceKey<Level>)event.getWorld().m_46472_(), player);
    }

    private static void swapGameMode(ResourceKey<Level> dimension, ServerPlayer player) {
        if (dimension.m_135782_().equals((Object)OVERWORLD) && player.f_8941_.m_9290_() != GameType.ADVENTURE && player.f_8941_.m_9290_() != GameType.CREATIVE) {
            player.m_143403_(GameType.ADVENTURE);
        }
        if (!dimension.m_135782_().equals((Object)OVERWORLD) && player.f_8941_.m_9290_() == GameType.ADVENTURE) {
            player.m_143403_(GameType.SURVIVAL);
        }
    }
}

